/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import icyllis.modernui.forge.NetworkHandler;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.chunk.LevelChunk;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.register.Channel;
import sonar.fluxnetworks.register.ClientMessages;
import sonar.fluxnetworks.register.Messages;

public class MUIChannel
extends Channel {
    private final NetworkHandler mNetwork = new NetworkHandler("fluxnetworks", () -> Holder::msg, Messages::msg, "707", true);

    MUIChannel() {
    }

    @Override
    public void sendToServer(@Nonnull FriendlyByteBuf payload) {
        this.mNetwork.sendToServer(payload);
    }

    @Override
    public void sendToPlayer(@Nonnull FriendlyByteBuf payload, @Nonnull ServerPlayer player) {
        this.mNetwork.sendToPlayer(payload, player);
    }

    @Override
    public void sendToAll(@Nonnull FriendlyByteBuf payload) {
        this.mNetwork.sendToAll(payload);
    }

    @Override
    public void sendToTrackingChunk(@Nonnull FriendlyByteBuf payload, @Nonnull LevelChunk chunk) {
        this.mNetwork.dispatch(payload).sendToTrackingChunk(chunk);
    }

    static {
        FluxNetworks.LOGGER.info("Use MUI network channel (high performance)");
    }

    private static class Holder {
        private Holder() {
        }

        @Nonnull
        static NetworkHandler.ClientListener msg() {
            return ClientMessages::msg;
        }
    }
}

